-------------------------------------

-------------------------------------

fighter_rt =
{
	touchAllMercsBusy = function()
		local touchBusy = function(index,value)
			Humans[value].lastBusyTime = time()
		end		
		table.foreach(CUR_MISSION.Mercs,touchBusy)
	end,

	onMercIdle = function(id)
		local list = {}

		local findIdles = function(index,value)
			if( (time()<Humans[value].lastBusyTime) or
				(time()-Humans[value].lastBusyTime>getAIConst().boredInterval-5)) then
				table.insert(list,value)
			end
		end
                table.foreach(CUR_MISSION.Mercs,findIdles)
                local cnt = table.getn(list)

                if(cnt>0) then
	                local rnd = math.random(cnt)
        	        id = CUR_MISSION.Mercs[rnd]

			local remark = nil
			local isPsycho = (string.upper(getPersonParameterStr(id, "PHOBIA")) == "PSYCHO") or
				(id=="long_tom") or (id=="ghost")
			local isMoralePositive = (getPersonParameter(id, "MORALE")>=60)
			local rnd = math.random(1,2)
			if(isMoralePositive) then
				if(not isPsycho) then
					rnd = math.random(1,3)
				end
				if(rnd==3) then
					remark = id.."_special_01"
				else
				        remark = id.."_social_0"..rnd
				end
			else
				local rnd = math.random(1,2)
				remark = id.."_social_negative_0"..rnd
			end
			if(     (remark ~= nil) and
				(remark~=Humans[id].last_remark) and
				service.showAck(id,remark,0.5)) then
				Humans[id].last_remark = remark
			end
			fighter_rt.touchAllMercsBusy()
		end
	end,

	think = function(id, time)
calls.enter("fighter_rt.think",id)

		memory.clearLastSeen(id)
		fighter_tb.lastTurnTeam = NONE

		if(not healthOK(id)) then
			setPersonParameter(id, "BREATH", 0)
			setPersonParameter(id, "AP", 0)
			log(id, "       ")
calls.leave("fighter_rt.think",id)
			if(addPose(id,"lie")) then
				executeOrders(id)
			end
			return
		end

		local clean = function(name, visible)
			if((name ~= "size") and (not IsAlive(name))) then
				service.removeFromVisibleL(id, name)
			end
		end

		if(isValid(Humans[id].visible_enemies)) then
			table.foreach(Humans[id].visible_enemies, clean)
		end

		if (service.isPlayer(id)) then
			if(ENTER_COMMENT_SAID == 0) then
				if(service.isThereEnemy(id)) then
					ENTER_COMMENT_SAID = 1
					local rnd = math.random(4)
					local merc = getRandomMerc()
					service.showAck(merc, merc.."_enemy_in_sector_0"..rnd, 1)
				end
			end

			if((WAS_TB == 1) or (Humans[id].lastBusyTime==nil)) then
				fighter_rt.touchAllMercsBusy()
			end

			if(WAS_TB == 1) then
				fighter_tb.onCombatFinished(id)
			end
			local x,y,z,f = getPosition(id)
			local posHash = x..y..z..f
			if(Humans[id].posHash~=posHash) then
				Humans[id].posHash = posHash
				Humans[id].lastBusyTime = time
			end
			if( (Humans[id].lastBusyTime>time) or
				(time-Humans[id].lastBusyTime>getAIConst().boredInterval)) then
				fighter_rt.onMercIdle(id)
			end
calls.leave("fighter_rt.think",id)
			return
		end

		Humans[id].surroundTurnsForSkip = 0
		Humans[id].leaderTurnsForSkip = 0
		Humans[id].last_strafe = NONE
		Humans[id].freeze = 0
		Humans[id].turnDone = false

		if(Humans[id].busy == 2) then
			Humans[id].busy = 0
			Humans[id].priority = 0
		end

		if(Humans[id].busy == 1) then
			if(getAPcost(id)<0) then
				log(id, "   .", Humans[id].freeze)
				Humans[id].busy = 0
				Humans[id].priority = 0
				Humans[id].going_behind = false
				clearAllOrders(id)				
calls.leave("fighter_rt.think",id)
				return
			end	
			Humans[id].busy = 2
			executeOrders(id)
		else
    			if(Humans[id].lastMoveCommand~=nil) then
				addSmartMove(id, Humans[id].lastMoveCommand.mode, 
					Humans[id].lastMoveCommand.x, Humans[id].lastMoveCommand.y, 
					Humans[id].lastMoveCommand.z, Humans[id].lastMoveCommand.f)
				Humans[id].lastMoveCommand = nil
			else
	    			local result = 0
				if(not service.isCivilian(id)) then
					result = b_soldier.rt_think(id, time)
				else
					result = b_civilian.rt_think(id, time)
				end
				if(result~=1) then
					Humans[id].busy = 0	
calls.leave("fighter_rt.think",id)
					return
				end
			end
			estimateAP(id)
			Humans[id].busy = 1						
		end
calls.leave("fighter_rt.think",id)
		return
	end,

	enemySighted = function(id, enemy)
calls.enter("fighter_rt.enemySighted",id)
		fighter_tb.enemySighted(id,enemy)
calls.leave("fighter_rt.enemySighted",id)
	end,

	enemySightedAgain = function(id, enemy)
calls.enter("fighter_rt.enemySightedAgain",id)
		fighter_tb.enemySightedAgain(id, enemy)
calls.leave("fighter_rt.enemySightedAgain",id)
	end,

	enemyHided = function(id, enemy)
calls.enter("fighter_rt.enemyHided",id)
		fighter_tb.enemyHided(id,enemy)
calls.leave("fighter_rt.enemyHided",id)
	end,

	neutralSighted = function(id, person)
calls.enter("fighter_rt.neutralSighted",id)
		fighter_tb.neutralSighted(id, person)
calls.leave("fighter_rt.neutralSighted",id)
	end,

	neutralHided = function(id, person)
calls.enter("fighter_rt.neutralHided",id)
		fighter_tb.neutralHided(id, person)
calls.leave("fighter_rt.neutralHided",id)
	end,

	allySighted = function(id, person)
calls.enter("fighter_rt.allySighted",id)
		fighter_tb.allySighted(id, person)
calls.leave("fighter_rt.allySighted",id)
	end,

	allyHided = function(id, person)
calls.enter("fighter_rt.allyHided",id)
		fighter_tb.allyHided(id, person)
calls.leave("fighter_rt.allyHided",id)
	end,

	teammateSighted = function(id, person)
calls.enter("fighter_rt.teammateSighted",id)
		fighter_tb.teammateSighted(id, person)
calls.leave("fighter_rt.teammateSighted",id)
	end,

	teammateHided = function(id, person)
calls.enter("fighter_rt.teammateHided",id)
		fighter_tb.teammateHided(id, person)
calls.leave("fighter_rt.teammateHided",id)
	end,
	
	corpseSighted = function(id, person)
calls.enter("fighter_rt.corpseSighted",id)
		fighter_tb.corpseSighted(id, person)
calls.leave("fighter_rt.corpseSighted",id)
	end,

	sound = function(id, stype, x, y, z, owner, time)
calls.enter("fighter_rt.sound",id..","..stype..","..owner)
		fighter_tb.sound(id, stype, x, y, z, owner, time)
calls.leave("fighter_rt.sound",id..","..stype..","..owner)
	end,

	splash = function(id, type, power)
calls.enter("fighter_rt.splash",id)
		fighter_tb.splash(id, type, power)
calls.leave("fighter_rt.splash",id)
	end,

	hurted = function(id, x, y, z, owner_id)
calls.enter("fighter_rt.splash",id..","..owner_id)
		fighter_tb.hurted(id, x, y, z, owner_id)
calls.leave("fighter_rt.splash",id..","..owner_id)
	end,

	teammateHurted = function(id, person)
calls.enter("fighter_rt.teammateHurted",id)
		fighter_tb.teammateHurted(id, person)
calls.leave("fighter_rt.teammateHurted",id)
	end,

	teammateDown = function(id, person)
calls.enter("fighter_rt.teammateDown",id)
		fighter_tb.teammateDown(id, person)
calls.leave("fighter_rt.teammateDown",id)
	end,

	stunned = function(id)
calls.enter("fighter_rt.stunned",id)
                fighter_tb.stunned(id)
calls.leave("fighter_rt.stunned",id)
	end,

	unstunned = function(id)
calls.enter("fighter_rt.unstunned",id)
		fighter_tb.unstunned(id)
calls.leave("fighter_rt.unstunned",id)
	end,

	blinded = function(id)
calls.enter("fighter_rt.blinded",id)
		fighter_tb.blinded(id)
calls.leave("fighter_rt.blinded",id)
	end,

	unblinded = function(id)
calls.enter("fighter_rt.unblinded",id)
		fighter_tb.unblinded(id)
calls.leave("fighter_rt.unblinded",id)
	end, 

	onTrigger = function(id, msg, trigger_name)
calls.enter("fighter_rt.onTrigger",id)
		fighter_tb.onTrigger(id, msg, trigger_name)
calls.leave("fighter_rt.onTrigger",id)
	end, 

	ordersChanged = function(id, current_priority)
calls.enter("fighter_rt.ordersChanged",id)
		fighter_tb.ordersChanged(id, current_priority)
calls.leave("fighter_rt.ordersChanged",id)
	end, 

	waitPresent = function(id, set)
calls.enter("fighter_rt.waitPresent",id)
		fighter_tb.waitPresent(id, set)
calls.leave("fighter_rt.waitPresent",id)
	end, 

	offenderPresent	= function(id, enemy)
calls.enter("fighter_rt.offenderPresent",id)
		fighter_tb.offenderPresent(id, enemy)
calls.leave("fighter_rt.offenderPresent",id)
	end, 
	
	
	rememberSounds = function(id)
calls.enter("fighter_rt.rememberSounds",id)
		fighter_tb.rememberSounds(id)
calls.leave("fighter_rt.rememberSounds",id)
	end, 
	

	shoutOffender = function(id, enemy)
calls.enter("fighter_rt.shoutOffender",id)
		fighter_tb.shoutOffender(id, enemy)
calls.leave("fighter_rt.shoutOffender",id)
	end,
	
	-------------------------------------------------
	--      
	updateKnownEnemyList = function(id, from_id, enemy_list)
calls.enter("fighter_rt.updateKnownEnemyList",id)
		fighter_tb.updateKnownEnemyList(id, from_id, enemy_list)
calls.leave("fighter_rt.updateKnownEnemyList",id)
	end,
	
	-------------------------------------------------
	--    
	commonAlarm = function(id, type, from_id)
calls.enter("fighter_rt.commonAlarm",id)
		fighter_tb.commonAlarm(id, type, from_id)
calls.leave("fighter_rt.commonAlarm",id)
	end,
	
	-------------------------------------------------
	--    
	localAlarm = function(id, type, from_id)
calls.enter("fighter_rt.localAlarm",id)
		fighter_tb.localAlarm(id, type, from_id)
calls.leave("fighter_rt.localAlarm",id)
	end,
	
	-------------------------------------------------
	--        
	reportVisibleEnemyListToOther = function(id, rel)
calls.enter("fighter_rt.reportVisibleEnemyListToOther",id)
		fighter_tb.reportVisibleEnemyListToOther(id, rel)
calls.leave("fighter_rt.reportVisibleEnemyListToOther",id)
	end,
	
	-------------------------------------------------
	--   
	-- type = {wound, sound, corpse}
	giveCommonAlarm = function(id, type, rel)
calls.enter("fighter_rt.giveCommonAlarm",id)
		fighter_tb.giveCommonAlarm(id, type, rel)
calls.leave("fighter_rt.giveCommonAlarm",id)
	end,
		
	-------------------------------------------------
	--   
	-- type = {wound, sound, corpse}
	giveLocalAlarm = function(id, type, rel, range)
calls.enter("fighter_rt.giveLocalAlarm",id)
		fighter_tb.giveLocalAlarm(id, type, rel, range)
calls.leave("fighter_rt.giveLocalAlarm",id)
	end,
}
